<?php echo $__env->make('header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

       <!--start content-->
       <main class="page-content">
        <!--breadcrumb-->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
          <div class="breadcrumb-title pe-3">Dashboard</div>
          <div class="ps-3">
            <nav aria-label="breadcrumb">
              <ol class="breadcrumb mb-0 p-0">
                <li class="breadcrumb-item"><a href="javascript:;"><i class="bx bx-home-alt"></i></a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">Products</li>
              </ol>
            </nav>
          </div>


        </div>
        <!--end breadcrumb-->

           <div class="card">
             <div class="card-body">
               <div class="d-flex align-items-center">
                  <h5 class="mb-0">Product Details</h5>
                   <form class="ms-auto position-relative">
                     <div class="position-absolute top-50 translate-middle-y search-icon px-3"><i class="bi bi-search"></i></div>
                     <input class="form-control ps-5" type="text" placeholder="search">
                   </form>
               </div>
              <form class="ms-auto" id="addForm" action="add_product" method="post">
                <?php echo csrf_field(); ?>
                <div class="btn-group">
                  <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#exampleVerticallycenteredModal">Add Products</button>

                  
                  <div class="modal fade" id="exampleVerticallycenteredModal" tabindex="-1" aria-hidden="true">
                    <div class="modal-dialog modal-dialog-centered">
                      <div class="modal-content">
                        <div class="modal-header border border-0">
                          <h5 class="modal-title">Add Product</h5>
                          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                          <div class="col-md-12 mb-3">
                            <label for="validationDefault01" class="form-label">Product Name</label>
                            <input type="text" id="product_name" name="name" class="form-control" id="validationDefault02" required>
                          </div>
                          <div class="col-md-12 mb-3">
                            <label for="validationDefault01" class="form-label">Product Price</label>
                            <input type="text" id="product_price" name="price" class="form-control" id="validationDefault02" required>
                          </div>
                        </div>
                        <div class="modal-footer border border-0">
                          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                          <button type="submit" data-bs-dismiss="modal" class="btn btn-primary">Save changes</button>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </form>
               <div class="table-responsive mt-3">
                 <table class="table align-middle">
                   <thead class="table-secondary">
                     <tr>
                      <th>#</th>
                      <th>Product Name</th>
                      <th>Product Price</th>
                      <th>Actions</th>
                     </tr>
                   </thead>
                   <tbody id="tableBody">
                        <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td>#</td>
                                <td><?php echo e($product->name); ?></td>
                                <td><?php echo e(number_format($product->price)); ?></td>
                                <td>
                                    <a class="text-primary" data-bs-toggle="modal" data-bs-target="#updateModal<?php echo e($product->id); ?>" title="Edit">
                                        <i class="bi bi-pencil-fill"></i>
                                    </a>
                                    <div class="modal fade" id="updateModal<?php echo e($product->id); ?>" tabindex="-1" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered">
                                            <form action="update_product" class="modal-content" method="post">
                                              <?php echo csrf_field(); ?>
                                                <div class="modal-header border border-0">
                                                    <h5 class="modal-title">Update Product</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    <input type="hidden" name="id" value="<?php echo e($product->id); ?>">

                                                    <div class="col-md-12 mb-3">
                                                        <label for="validationDefault02" class="form-label">Name</label>
                                                        <input type="text" name="name" id="name" value="<?php echo e($product->name); ?>" class="form-control" required="">
                                                    </div>
                                                    
                                                    <div class="col-md-12 mb-3">
                                                        <label for="validationDefault02" class="form-label">Price</label>
                                                        <input type="number" name="price" id="price" value="<?php echo e($product->price); ?>" class="form-control" required="">
                                                    </div>
                                                </div>
                                                <div class="modal-footer border border-0">
                                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                                    <button type="submit" class="btn btn-primary">
                                                        Save changes
                                                    </button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>

                                    <a href="delete_product/<?php echo e($product->id); ?>" class="text-danger">
                                        <i class="bi bi-trash-fill"></i>
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                   </tbody>
                 </table>
               </div>
             </div>
           </div>

       </main>
       <!--end page main-->
<?php echo $__env->make('footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\factory_v2\resources\views/products.blade.php ENDPATH**/ ?>