<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>AdminLTE 3 | Invoice Print</title>

  <!-- Google Font: Source Sans Pro -->
  <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="<?php echo e(asset('plugins/fontawesome-free/css/all.min.css')); ?>">
  <!-- Theme style -->
  <link rel="stylesheet" href="<?php echo e(asset('dist/css/adminlte.min.css')); ?>">
</head>
<body>
<div class="wrapper">
  <!-- Main content -->
  <section class="invoice">
    <!-- title row -->
    <div class="row">
        <div class="col-12 text-center">
            <h3>
            Sonnex Surplus Industries Ltd.
            </h3>
            <p>Dealers On Home Care Plastic Products Gift Items and Take-aways</p>
        </div>
      <!-- /.col -->
    </div>
    <!-- info row -->
        <div class="row invoice-info">
                <div class="col-sm-6 invoice-col">
                  <address>
                    <strong>Head Office:</strong><br>
                    B32 God's Favour Line Plastic Market<br>
                    Near Coca Cola,<br>
                    By/Asaba - Onitsha Expressway,<br>
                    Phone: 07035412695, 07088238454, 08182067371<br>
                  </address>
                </div>
                <!-- /.col -->

                <!-- /.col -->
                <div class="col-sm-6 invoice-col">
                  <address class="float-right">
                    <strong>Warehouse:</strong><br>
                    109 Obodoukwu Road<br>
                  </address>
                  
                </div>
                <!-- /.col -->
        </div>
    <!-- /.row -->

    <!-- Table row -->
    <div class="row">
        <div class="col-12 table-responsive">
            <table class="table table-striped">
            <thead>
                
            <tr>
                <th>SN</th>
                
                <th>Product</th>
                <th>Qty</th>
                <th>Price Per Unit</th>
                <th>Subtotal</th>
            </tr>
            </thead>
            <tfoot>
                <tr>
                    <td colspan="3"></td>
                    <td>Total:</td>
                    <td>&#x20A6;<?php echo e(number_format($invoice->amount)); ?></td>
                </tr>
            </tfoot>
            <tbody>
            <?php
                $count=1;
            ?>
            <?php $__currentLoopData = $sales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sale): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($count); ?></td>
                <td><?php echo e($sale->stock->product->item); ?></td>
                <td><?php echo e($sale->quantity); ?></td>
                <td>&#x20A6;<?php echo e(number_format($sale->stock->product->selling_price,2)); ?></td>                      
                <td>&#x20A6;<?php echo e(number_format($sale->amount,2)); ?></td>
            </tr>
            <?php
                $count++;
            ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            </tbody>
            </table>
        </div>
        <!-- /.col -->
    </div>
    <!-- /.row -->

    <div class="row">

        <div class="col-md-6">
                <p style="font-size:18px !important">
                <b>Customer Name:</b> <?php echo e($invoice->customer->fullname); ?> <br>
                <b>Phone:</b> <?php echo e($invoice->customer->phone); ?> <br>
                <b>Address:</b> <?php echo e($invoice->customer->address); ?> <br>
                <b>Invoice no:</b> #<?php echo e($invoice->log); ?><br>
                <br>
                <b>Amount Paid:</b> &#x20A6;<?php echo e(number_format($invoice->amount - $invoice->balance,2)); ?><br>
                <b>Balance:</b> &#x20A6;<?php echo e(number_format($invoice->balance,2)); ?><br>
                <b>Payment Type:</b> <?php echo e($invoice->payment_type); ?> <br>
                <b>Payment Date:</b> <?php echo e(date('jS F Y',strtotime($invoice->created_at))); ?><br>
                <br>
                </p>
        </div>
    </div>
    <!-- /.row -->
  </section>
  <!-- /.content -->
</div>
<!-- ./wrapper -->
<!-- Page specific script -->
<script>
  window.addEventListener("load", window.print());
</script>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\plastics.sonnex.com\resources\views/invoice_print.blade.php ENDPATH**/ ?>