<?php echo $__env->make('header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<!--start content-->
       <main class="page-content">
        <!--breadcrumb-->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
          <div class="breadcrumb-title pe-3">Dashboard</div>
          <div class="ps-3">
            <nav aria-label="breadcrumb">
              <ol class="breadcrumb mb-0 p-0">
                <li class="breadcrumb-item"><a href="javascript:;"><i class="bx bx-home-alt"></i></a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">Inventory</li>
              </ol>
            </nav>
          </div>

          
        </div>
        <!--end breadcrumb-->

           <div class="card">
             <div class="card-body">
               <div class="d-flex align-items-center">
                  <h5 class="mb-0">Production Details</h5>
                   <form class="ms-auto position-relative">
                     <div class="position-absolute top-50 translate-middle-y search-icon px-3"><i class="bi bi-search"></i></div>
                     <input class="form-control ps-5" type="text" placeholder="search">
                   </form>
               </div>
              <form class="ms-auto" id="addForm" action="add_production" method="post">
                <?php echo csrf_field(); ?>
                <div class="btn-group">
                  <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#exampleVerticallycenteredModal">Add Production</button>

                  
                  <div class="modal fade" id="exampleVerticallycenteredModal" tabindex="-1" aria-hidden="true">
                    <div class="modal-dialog modal-dialog-centered">
                      <div class="modal-content">
                        <div class="modal-header border border-0">
                          <h5 class="modal-title">Add Production</h5>
                          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <div class="modal-body">


                          <div class="col-md-12 mb-3">
                            <label for="validationDefault02" class="form-label">Description</label>
                            <textarea id="description" name="description" class="form-control" id="validationDefault02" value="" rows="3" style="resize:none" required></textarea>
                          </div>

                          <div class="col-md-12 mb-3">
                            <label for="validationDefault01" class="form-label">Product name</label>
                            <select class="form-control" id="product_list" name="product_id">
                                <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                  <option value="<?php echo e($product->id); ?>"><?php echo e($product->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                          </div>

                          <div class="col-md-12 mb-3">
                            <label for="validationDefault01" class="form-label">Material name</label>
                            <select class="form-control" id="material_list" name="material_id">
                              <?php $__currentLoopData = $materials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $material): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                  <option value="<?php echo e($material->id); ?>"><?php echo e($material->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                          </div>
                          <div class="col-md-12 mb-3">
                            <label for="validationDefault02" class="form-label">Input Tonnage</label>
                            <input type="number" id="input_tonnage" name="input_tonnage" class="form-control" id="validationDefault02" value="" required>
                          </div>

                          <div class="col-md-12 mb-3">
                            <label for="validationDefault02" class="form-label">Output Tonnage</label>
                            <input type="number" id="output_tonnage" name="output_tonnage" class="form-control" id="validationDefault02" value="" required>
                          </div>
                        </div>
                        <div class="modal-footer border border-0">
                          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                          <button type="submit" data-bs-dismiss="modal" class="btn btn-primary">Save changes</button>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </form>
               <div class="table-responsive mt-3">
                 <table class="table align-middle">
                   <thead class="table-secondary">
                     <tr>
                      <th>#</th>
                      <th>Log</th>
                      <th>Description</th>
                      <th>Product Name</th>
                      <th>Material Name</th>
                      <th>Input Tonnage</th>
                      <th>Output Tonnage</th>
                      <th>Actions</th>
                     </tr>
                   </thead>
                   <tbody id="tableBody">
                        <?php $__currentLoopData = $productions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $production): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td>#</td>
                                <td><?php echo e($production->log); ?></td>
                                <td><?php echo e($production->description); ?></td>
                                <td><?php echo e($production->product->name); ?></td>
                                <td><?php echo e($production->material->name); ?></td>
                                <td><?php echo e($production->input_tonnage); ?></td>
                                <td><?php echo e($production->output_tonnage); ?></td>
                                <td>
                                    <a class="text-primary" data-bs-toggle="modal" data-bs-target="#updateModal<?php echo e($production->id); ?>" title="Edit">
                                        <i class="bi bi-pencil-fill"></i>
                                    </a>
                                    <div class="modal fade" id="updateModal<?php echo e($production->id); ?>" tabindex="-1" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered">
                                            <form action="update_production" method="post" class="modal-content">
                                              <?php echo csrf_field(); ?>
                                                <div class="modal-header border border-0">
                                                    <h5 class="modal-title">Update Production</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    <input type="hidden" name="update" value="update">
                                                    <input type="hidden" name="id" value="<?php echo e($production->id); ?>">

                                                    <div class="col-md-12 mb-3">
                                                        <label for="validationDefault02" class="form-label">Description</label>
                                                        <textarea name="description" id="" class="form-control" cols="30" rows="5"><?php echo e($production->description); ?></textarea>
                                                    </div>

                                                    

                                                    <div class="col-md-12 mb-3">
                                                        <label for="validationDefault01" class="form-label">Product name</label>
                                                        <select name="product_id" class="form-control product_list2" id="product_list2">
                                                            <option value="<?php echo e($production->product->id); ?>"><?php echo e($production->product->name); ?></option>
                                                            <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($product->id); ?>"><?php echo e($product->name); ?></option>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </select>
                                                    </div>

                                                    <div class="col-md-12 mb-3">
                                                        <label for="validationDefault01" class="form-label">Material name</label>
                                                        <select name="material_id" class="form-control product_list2" id="product_list2">
                                                            <option value="<?php echo e($production->material->id); ?>"><?php echo e($production->material->name); ?></option>
                                                            <?php $__currentLoopData = $materials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $material): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($material->id); ?>"><?php echo e($material->name); ?></option>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </select>
                                                    </div>


                                                    <div class="col-md-12 mb-3">
                                                        <label for="validationDefault02" class="form-label">Input Tonnage</label>
                                                        <input type="text" name="input_tonnage" id="input_tonnage" value="<?php echo e($production->input_tonnage); ?>" class="form-control" required="">
                                                    </div>

                                                    <div class="col-md-12 mb-3">
                                                        <label for="validationDefault02" class="form-label">Output Tonnage</label>
                                                        <input type="text" name="output_tonnage" id="output_tonnage" value="<?php echo e($production->output_tonnage); ?>" class="form-control" required="">
                                                    </div>
                                                   
                                                </div>
                                                <div class="modal-footer border border-0">
                                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                                    <button type="submit" class="btn btn-primary">
                                                        Save changes
                                                    </button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>

                                    <a href="delete_production/<?php echo e($production->id); ?>" class="text-danger">
                                        <i class="bi bi-trash-fill"></i>
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                   </tbody>
                 </table>
               </div>
             </div>
           </div>

       </main>
       <!--end page main-->
<?php echo $__env->make('footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\factory_v2\resources\views/production.blade.php ENDPATH**/ ?>