@include('header')
       <!--start content-->
       <main class="page-content">
        <!--breadcrumb-->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
          <div class="breadcrumb-title pe-3">Dashboard</div>
          <div class="ps-3">
            <nav aria-label="breadcrumb">
              <ol class="breadcrumb mb-0 p-0">
                <li class="breadcrumb-item"><a href="javascript:;"><i class="bx bx-home-alt"></i></a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">Suppliers</li>
              </ol>
            </nav>
          </div>

        </div>
        <!--end breadcrumb-->

           <div class="card">
             <div class="card-body">
               <div class="d-flex align-items-center">
                  <h5 class="mb-0">Suppliers</h5>
                   <form class="ms-auto position-relative">
                     <div class="position-absolute top-50 translate-middle-y search-icon px-3"><i class="bi bi-search"></i></div>
                     <input class="form-control ps-5" type="text" placeholder="search">
                   </form>
               </div>

          <form class="ms-auto" id="addForm" method="post" action="add_supplier">
            @csrf
            <div class="btn-group">
              <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#exampleVerticallycenteredModal">Add Supplier</button>

              
              <div class="modal fade" id="exampleVerticallycenteredModal" tabindex="-1" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered">
                  <div class="modal-content">
                    <div class="modal-header border border-0">
                      <h5 class="modal-title">Add Supplier</h5>
                      <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">



                      <div class="col-md-12 mb-3">
                        <label for="validationDefault01" class="form-label">Full name</label>
                        <input type="text" name="name" class="form-control" value="" required>
                      </div>
                      <div class="col-md-12 mb-3">
                        <label for="validationDefault01" class="form-label">Email</label>
                        <input type="text" name="email" class="form-control" value="" required>
                      </div>
                      <div class="col-md-12 mb-3">
                        <label for="validationDefault01" class="form-label">Phone</label>
                        <input type="text" name="phone" class="form-control" value="" required>
                      </div>

                      <div class="col-md-12 mb-3">
                        <label for="validationDefault01" class="form-label">Address</label>
                        <input type="text" name="address" class="form-control" value="" required>
                      </div>
                    </div>
                    <div class="modal-footer border border-0">
                      <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                      <button type="submit" data-bs-dismiss="modal" class="btn btn-primary">Save changes</button>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </form>               
               <div class="table-responsive mt-3">
                 <table class="table align-middle">
                   <thead class="table-secondary">
                     <tr>
                      <th>#</th>
                      <th>Name</th>
                      <th>Email</th>
                      <th>Phone</th>
                      <th>Address</th>
                      <th>Actions</th>
                     </tr>
                   </thead>
                   <tbody id="tableBody">
                    @foreach($suppliers as $supplier)
                          <tr>
                            <td>#</td>
                            <td>{{$supplier->name}}</td>
                            <td>{{$supplier->email}}</td>
                            <td>{{$supplier->phone}}</td>
                            <td>{{$supplier->address}}</td>
                            <td>
                                    <a class="text-primary" data-bs-toggle="modal" data-bs-target="#updateModal{{$supplier->id}}" title="Edit">
                                        <i class="bi bi-pencil-fill"></i>
                                    </a>
                                    <div class="modal fade" id="updateModal{{$supplier->id}}" tabindex="-1" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered">
                                            <form action="update_supplier" class="modal-content" method="post">
                                              @csrf
                                                <div class="modal-header border border-0">
                                                    <h5 class="modal-title">Update Customer</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    <input type="hidden" name="id" value="{{$supplier->id}}">

                                                    <div class="col-md-12 mb-3">
                                                      <label for="validationDefault01" class="form-label">Full name</label>
                                                      <input type="text" name="name" class="form-control" value="{{$supplier->name}}" required>
                                                    </div>
                                                    <div class="col-md-12 mb-3">
                                                      <label for="validationDefault01" class="form-label">Email</label>
                                                      <input type="text" name="email" class="form-control" value="{{$supplier->email}}" required>
                                                    </div>
                                                    <div class="col-md-12 mb-3">
                                                      <label for="validationDefault01" class="form-label">Phone</label>
                                                      <input type="text" name="phone" class="form-control" value="{{$supplier->phone}}" required>
                                                    </div>

                                                    <div class="col-md-12 mb-3">
                                                      <label for="validationDefault01" class="form-label">Address</label>
                                                      <input type="text" name="address" class="form-control" value="{{$supplier->address}}" required>
                                                    </div>
                                                </div>
                                                <div class="modal-footer border border-0">
                                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                                    <button type="submit" class="btn btn-primary">
                                                        Save changes
                                                    </button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>

                                    <a href="delete_supplier/{{$supplier->id}}" class="text-danger">
                                        <i class="bi bi-trash-fill"></i>
                                    </a>

                            </td>
                          </tr>

                     @endforeach
                   </tbody>
                 </table>
               </div>
             </div>
           </div>

       </main>
       <!--end page main-->

       <!--start overlay-->
        <div class="overlay nav-toggle-icon"></div>
       <!--end overlay-->

       <!--start footer-->
       <footer class="footer">
        <div class="footer-text">
           Copyright © 2022. All right reserved.
        </div>
        </footer>
        <!--end footer-->

       <!--Start Back To Top Button-->
		     <a href="javaScript:;" class="back-to-top"><i class='bx bxs-up-arrow-alt'></i></a>
       <!--End Back To Top Button-->

       <!--start switcher-->
       <div class="switcher-body">
        <button class="btn btn-primary btn-switcher shadow-sm" type="button" data-bs-toggle="offcanvas" data-bs-target="#offcanvasScrolling" aria-controls="offcanvasScrolling"><i class="bi bi-paint-bucket me-0"></i></button>
        <div class="offcanvas offcanvas-end shadow border-start-0 p-2" data-bs-scroll="true" data-bs-backdrop="false" tabindex="-1" id="offcanvasScrolling">
          <div class="offcanvas-header border-bottom">
            <h5 class="offcanvas-title" id="offcanvasScrollingLabel">Theme Customizer</h5>
            <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas"></button>
          </div>
          <div class="offcanvas-body">
            <h6 class="mb-0">Theme Variation</h6>
            <hr>
            <div class="form-check form-check-inline">
              <input class="form-check-input" type="radio" name="inlineRadioOptions" id="LightTheme" value="option1">
              <label class="form-check-label" for="LightTheme">Light</label>
            </div>
            <div class="form-check form-check-inline">
              <input class="form-check-input" type="radio" name="inlineRadioOptions" id="DarkTheme" value="option2">
              <label class="form-check-label" for="DarkTheme">Dark</label>
            </div>
            <div class="form-check form-check-inline">
              <input class="form-check-input" type="radio" name="inlineRadioOptions" id="SemiDarkTheme" value="option3">
              <label class="form-check-label" for="SemiDarkTheme">Semi Dark</label>
            </div>
            <hr>
            <div class="form-check form-check-inline">
              <input class="form-check-input" type="radio" name="inlineRadioOptions" id="MinimalTheme" value="option3" checked>
              <label class="form-check-label" for="MinimalTheme">Minimal Theme</label>
            </div>
            <hr/>
            <h6 class="mb-0">Header Colors</h6>
            <hr/>
            <div class="header-colors-indigators">
              <div class="row row-cols-auto g-3">
                <div class="col">
                  <div class="indigator headercolor1" id="headercolor1"></div>
                </div>
                <div class="col">
                  <div class="indigator headercolor2" id="headercolor2"></div>
                </div>
                <div class="col">
                  <div class="indigator headercolor3" id="headercolor3"></div>
                </div>
                <div class="col">
                  <div class="indigator headercolor4" id="headercolor4"></div>
                </div>
                <div class="col">
                  <div class="indigator headercolor5" id="headercolor5"></div>
                </div>
                <div class="col">
                  <div class="indigator headercolor6" id="headercolor6"></div>
                </div>
                <div class="col">
                  <div class="indigator headercolor7" id="headercolor7"></div>
                </div>
                <div class="col">
                  <div class="indigator headercolor8" id="headercolor8"></div>
                </div>
              </div>
            </div>
          </div>
        </div>
       </div>
       <!--end switcher-->

  </div>
  <!--end wrapper-->


  <!-- Bootstrap bundle JS -->
  <script src="assets/js/bootstrap.bundle.min.js"></script>
  <!--plugins-->
    <script src="assets/js/jquery.min.js"></script>
  <script src="js/session_check.js"></script>
  <script src="assets/plugins/simplebar/js/simplebar.min.js"></script>
  <script src="assets/plugins/metismenu/js/metisMenu.min.js"></script>
  <script src="assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js"></script>
  <script src="assets/plugins/vectormap/jquery-jvectormap-2.0.2.min.js"></script>
  <script src="assets/plugins/vectormap/jquery-jvectormap-world-mill-en.js"></script>
  <script src="assets/js/pace.min.js"></script>
  <script src="assets/plugins/chartjs/js/Chart.min.js"></script>
  <script src="assets/plugins/chartjs/js/Chart.extension.js"></script>
  <script src="assets/plugins/apexcharts-bundle/js/apexcharts.min.js"></script>
  <script src="assets/plugins/select2/js/select2.min.js"></script>
  <script src="assets/js/form-select2.js"></script>
  <!--app-->
  <script src="assets/js/app.js"></script>
  <script src="assets/js/index4.js"></script>
  <script>
    new PerfectScrollbar(".best-product")
 </script>
 <script src="js/suppliers.js"></script>


<script>
  $(document).ready(function() {
      
      // Send an AJAX request to execute the sessionmanager.php script
      $.ajax({
          url: 'php/session_check.php',
          method: 'GET',
          success: function(response) {
            const myObj = JSON.parse(response);
            console.log(myObj)
            document.getElementById('name').innerHTML = myObj.username;
              console.log(myObj.username);
          },
          error: function(xhr, status, error) {
              console.error("Error: " + error);
          }
      });
  });
</script>

</body>

</html>