      @include('header')   
        <!--start content-->
       <main class="page-content">
        <!--breadcrumb-->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
          <div class="breadcrumb-title pe-3">Dashboard</div>
          <div class="ps-3">
            <nav aria-label="breadcrumb">
              <ol class="breadcrumb mb-0 p-0">
                <li class="breadcrumb-item"><a href="javascript:;"><i class="bx bx-home-alt"></i></a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">Inventory</li>
              </ol>
            </nav>
          </div>

          
        </div>
        <!--end breadcrumb-->

           <div class="card">
             <div class="card-body">
               <div class="d-flex align-items-center">
                  <h5 class="mb-0">Inventory Details</h5>
                   <form class="ms-auto position-relative">
                     <div class="position-absolute top-50 translate-middle-y search-icon px-3"><i class="bi bi-search"></i></div>
                     <input class="form-control ps-5" type="text" placeholder="search">
                   </form>
               </div>
               

               @if (session('success'))
                <script>
                  
                    // Run the notification after page load
                    document.addEventListener('DOMContentLoaded', function() {
                        console.log('show notice')
                        success_noti("{{ session('success') }}");
                    });
                </script>
                @endif
               <form class="ms-auto" id="addForm" method="post" action="add_inventory">
                  @csrf
                  <div class="btn-group">
                    <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#exampleVerticallycenteredModal">Add Inventory</button>

                    
                    <div class="modal fade" id="exampleVerticallycenteredModal" tabindex="-1" aria-hidden="true">
                      <div class="modal-dialog modal-dialog-centered">
                        <div class="modal-content">
                          <div class="modal-header border border-0">
                            <h5 class="modal-title">Add Inventory</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                          </div>
                          <div class="modal-body">



                            <div class="col-md-12 mb-3">
                              <label for="validationDefault01" class="form-label">Product name</label>
                              <select class="form-control" id="product_list" name="product_id">
                                @foreach($products as $product)
                                    <option value="{{$product->id}}">{{$product->name}}</option>
                                @endforeach
                              </select>
                            </div>
                            <div class="col-md-12 mb-3">
                              <label for="validationDefault02" class="form-label">Quantity</label>
                              <input type="number" id="quantity" name="quantity" class="form-control" id="validationDefault02" value="" required>
                            </div>

                            
                            
                            



                          </div>
                          <div class="modal-footer border border-0">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                            <button type="submit" data-bs-dismiss="modal" class="btn btn-primary">Save changes</button>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </form>
               <div class="table-responsive mt-3">
                 <table class="table align-middle">
                   <thead class="table-secondary">
                     <tr>
                      <th>#</th>
                      <th>Product Name</th>
                      <th>Quantity</th>
                      <th>Actions</th>
                     </tr>
                   </thead>
                   <tbody id="tableBody">
                        @foreach($inventories as $inventory)
                            <tr>
                                <td>#</td>
                                <td>{{$inventory->product->name}}</td>
                                <td>{{$inventory->quantity}}</td>
                                <td>
                                    <a class="text-primary" data-bs-toggle="modal" data-bs-target="#updateModal{{$inventory->id}}" title="Edit">
                                        <i class="bi bi-pencil-fill"></i>
                                    </a>
                                    <div class="modal fade" id="updateModal{{$inventory->id}}" tabindex="-1" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered">
                                            <form action="update_inventory" class="modal-content" method="post">
                                                @csrf
                                                <div class="modal-header border border-0">
                                                    <h5 class="modal-title">Update Inventory</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    <input type="hidden" name="id" value="{{$inventory->id}}">
                                                    <div class="col-md-12 mb-3">
                                                        <label for="validationDefault01" class="form-label">Product name</label>
                                                        <select name="product_id" class="form-control product_list2" id="product_list2">
                                                            <option value="{{$inventory->product->id}}">{{$inventory->product->name}}</option>
                                                            @foreach($products as $product)
                                                            <option value="{{$product->id}}">{{$product->name}}</option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                    <div class="col-md-12 mb-3">
                                                        <label for="validationDefault02" class="form-label">Quantity</label>
                                                        <input type="number" name="quantity" id="quantity" value="{{$inventory->quantity}}" class="form-control" required="">
                                                    </div>
                                                </div>
                                                <div class="modal-footer border border-0">
                                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                                    <button type="submit" class="btn btn-primary">
                                                        Save changes
                                                    </button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>

                                    <a href="delete_inventory/{{$inventory->id}}" class="text-danger">
                                        <i class="bi bi-trash-fill"></i>
                                    </a>
                                </td>
                            </tr>
                        @endforeach
                   </tbody>
                 </table>
               </div>
             </div>
           </div>

       </main>
       <!--end page main-->
       @include('footer')

                <script>
                  function success_noti(message) {
                      Lobibox.notify('success', {
                          pauseDelayOnHover: true,
                          continueDelayOnInactiveTab: false,
                          position: 'top right',
                          icon: 'bx bx-check-circle',
                          msg: message
                      });
                  }
              </script>