@include('header')

       <!--start content-->
       <main class="page-content">
        <!--breadcrumb-->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
          <div class="breadcrumb-title pe-3">Dashboard</div>
          <div class="ps-3">
            <nav aria-label="breadcrumb">
              <ol class="breadcrumb mb-0 p-0">
                <li class="breadcrumb-item"><a href="javascript:;"><i class="bx bx-home-alt"></i></a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">Users</li>
              </ol>
            </nav>
          </div>

          
        </div>
        <!--end breadcrumb-->

           <div class="card">
             <div class="card-body">
               <div class="d-flex align-items-center">
                  <h5 class="mb-0">Customer</h5>
                   <form class="ms-auto position-relative">
                     <div class="position-absolute top-50 translate-middle-y search-icon px-3"><i class="bi bi-search"></i></div>
                     <input class="form-control ps-5" type="text" placeholder="search">
                   </form>
               </div>
          <form class="ms-auto" id="addForm" method="post" action="add_customer">
            @csrf
            <div class="btn-group">
              <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#exampleVerticallycenteredModal">Add Customer</button>

              
              <div class="modal fade" id="exampleVerticallycenteredModal" tabindex="-1" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered">
                  <div class="modal-content">
                    <div class="modal-header border border-0">
                      <h5 class="modal-title">Add Customer</h5>
                      <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">



                      <div class="col-md-12 mb-3">
                        <label for="validationDefault01" class="form-label">Full name</label>
                        <input type="text" name="name" class="form-control" value="" required>
                      </div>
                      <div class="col-md-12 mb-3">
                        <label for="validationDefault01" class="form-label">Email</label>
                        <input type="text" name="email" class="form-control" value="" required>
                      </div>
                      <div class="col-md-12 mb-3">
                        <label for="validationDefault01" class="form-label">Phone</label>
                        <input type="text" name="phone" class="form-control" value="" required>
                      </div>

                      <div class="col-md-12 mb-3">
                        <label for="validationDefault01" class="form-label">Address</label>
                        <input type="text" name="address" class="form-control" value="" required>
                      </div>
                    </div>
                    <div class="modal-footer border border-0">
                      <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                      <button type="submit" data-bs-dismiss="modal" class="btn btn-primary">Save changes</button>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </form>               
               <div class="table-responsive mt-3">
                 <table class="table align-middle">
                   <thead class="table-secondary">
                     <tr>
                      <th>#</th>
                      <th>Name</th>
                      <th>Email</th>
                      <th>Phone</th>
                      <th>Address</th>
                      <th>Actions</th>
                     </tr>
                   </thead>
                   <tbody id="tableBody">
                      @foreach($customers as $customer)
                          <tr>
                            <td>#</td>
                            <td>{{$customer->name}}</td>
                            <td>{{$customer->email}}</td>
                            <td>{{$customer->phone}}</td>
                            <td>{{$customer->address}}</td>
                            <td>
                                    <a class="text-primary" data-bs-toggle="modal" data-bs-target="#updateModal{{$customer->id}}" title="Edit">
                                        <i class="bi bi-pencil-fill"></i>
                                    </a>
                                    <div class="modal fade" id="updateModal{{$customer->id}}" tabindex="-1" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered">
                                            <form action="update_customer" class="modal-content" method="post">
                                              @csrf
                                                <div class="modal-header border border-0">
                                                    <h5 class="modal-title">Update Customer</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    <input type="hidden" name="id" value="{{$customer->id}}">

                                                    <div class="col-md-12 mb-3">
                                                      <label for="validationDefault01" class="form-label">Full name</label>
                                                      <input type="text" name="name" class="form-control" value="{{$customer->name}}" required>
                                                    </div>
                                                    <div class="col-md-12 mb-3">
                                                      <label for="validationDefault01" class="form-label">Email</label>
                                                      <input type="text" name="email" class="form-control" value="{{$customer->email}}" required>
                                                    </div>
                                                    <div class="col-md-12 mb-3">
                                                      <label for="validationDefault01" class="form-label">Phone</label>
                                                      <input type="text" name="phone" class="form-control" value="{{$customer->phone}}" required>
                                                    </div>

                                                    <div class="col-md-12 mb-3">
                                                      <label for="validationDefault01" class="form-label">Address</label>
                                                      <input type="text" name="address" class="form-control" value="{{$customer->address}}" required>
                                                    </div>
                                                </div>
                                                <div class="modal-footer border border-0">
                                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                                    <button type="submit" class="btn btn-primary">
                                                        Save changes
                                                    </button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>

                                    <a href="delete_customer/{{$customer->id}}" class="text-danger">
                                        <i class="bi bi-trash-fill"></i>
                                    </a>

                            </td>
                          </tr>

                     @endforeach
                   </tbody>
                 </table>
               </div>
             </div>
           </div>

       </main>
       <!--end page main-->
@include('footer')